/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.mixin;

import io.github.apace100.origins.access.EntityShapeContextAccessor;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.PhasingPower;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.EntitySelectionContext;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractBlock.AbstractBlockState.class})
public abstract class AbstractBlockStateMixin {
    @Shadow
    public abstract Block func_177230_c();

    @Shadow
    protected abstract BlockState func_230340_p_();

    @Shadow
    public abstract VoxelShape func_196954_c(IBlockReader var1, BlockPos var2);

    @Inject(at={@At(value="HEAD")}, method={"getCollisionShape(Lnet/minecraft/world/BlockView;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/ShapeContext;)Lnet/minecraft/util/shape/VoxelShape;"}, cancellable=true)
    private void phaseThroughBlocks(IBlockReader world, BlockPos pos, ISelectionContext context, CallbackInfoReturnable<VoxelShape> info) {
        Entity entity;
        VoxelShape blockShape = this.func_177230_c().func_220071_b(this.func_230340_p_(), world, pos, context);
        if (!blockShape.func_197766_b() && context instanceof EntitySelectionContext && (entity = EntityShapeContextAccessor.getEntity((EntitySelectionContext)context)) != null) {
            boolean isAbove = this.isAbove(entity, blockShape, pos, false);
            for (PhasingPower phasingPower : OriginComponent.getPowers(entity, PhasingPower.class)) {
                if (isAbove && !phasingPower.shouldPhaseDown((PlayerEntity)entity) || !phasingPower.doesApply(pos)) continue;
                info.setReturnValue((Object)VoxelShapes.func_197880_a());
            }
        }
    }

    @Unique
    private boolean isAbove(Entity entity, VoxelShape shape, BlockPos pos, boolean defaultValue) {
        return entity.func_226278_cu_() > (double)pos.func_177956_o() + shape.func_197758_c(Direction.Axis.Y) - (entity.func_233570_aj_() ? 0.503125 : 0.0015);
    }

    @Inject(method={"onEntityCollision"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventCollisionWhenPhasing(World world, BlockPos pos, Entity entity, CallbackInfo ci) {
        for (PhasingPower phasingPower : OriginComponent.getPowers(entity, PhasingPower.class)) {
            if (!phasingPower.doesApply(pos)) continue;
            ci.cancel();
        }
    }
}

